/*global define, require */
/*jslint white: true */

/*
	AudioClip:

	This object provides a mixin for each audio clip.
*/

define(["src/utils", "src/build/treeLeaf", "src/build/changeNotifier", "src/build/TimeItem", "src/build/AudibleItem"],
function(utils, treeLeaf, changeNotifier, TimeItem, AudibleItem) {
	'use strict';

	function AudioClip(inTypeName, inClipName, inPlayASAP, inRecordedSpeed) {
		this.TimeItem("TimeItem");
		this.AudibleItem("AudibleItem");

		// do not modify these private members directly or notifiers won't be called correctly
		this.pClip = { 
			name            : inClipName, 
			typeName        : inTypeName, 
			parent          : undefined,
			changeNotifiers	: undefined,
			playASAP		: inPlayASAP,
			recordedSpeed	: inRecordedSpeed
		};
	}

	utils.mixin(AudioClip, 
		TimeItem, 
		AudibleItem,
		treeLeaf({ 
			parentLabel   : "parent", 
			getTreeInfo : function (obj) {
				return obj.pClip;
			}
		}),
		changeNotifier({
			notifiersLabel	: "changeNotifiers", 
			getTreeInfo : function (obj) {
				return obj.pClip;
			}
		}),
		{
			getTypeName : function () {
				return this.pClip.typeName;
			},

			setName : function (name) {
				this.pClip.name = name;
				this.callChangeNotifiers("nameChanged");
			},

			// const return value
			getName : function () {
				return this.pClip.name;
			},

			getPlayASAP : function () {
				return this.pClip.playASAP;
			},
		
			getRecordedSpeed : function () {
				return this.pClip.recordedSpeed || 1.0;
			},
		
			removeChangeNotifiers: function () {
				this.removeAllChangeNotifiers();
			},

			// function types:
			// "nameChanged"
			// "parentChanged"
			// "audibleChanged"
			// "childAdded"
			// "childRemoved"
			clone : function (clone_children, other) {
				var result = other;

				if (result) {
					// init
					AudioClip.call(result);
				} else {
					// alloc and init
					result = new AudioClip();
				}

				utils.clone(false, result.pClip, this.pClip);

				// clone node state
				AudibleItem.prototype.clone.call(this, clone_children, result);

				delete result.pClip.parent;
				delete result.pClip.changeNotifiers;
				result.setParent(undefined);

				return result;
			}
		}
	);

	return AudioClip;
});
